local t = Def.ActorFrame {
	Def.Quad{
		InitCommand=cmd(FullScreen;diffuse,color("0,0,0,0"););
		OnCommand=cmd(sleep,0.5;linear,1.5;diffusealpha,1);
	};

	-- Cleared
	Def.ActorFrame {
		Name="ClearedFrame";
		Condition=GAMESTATE:GetPlayMode() ~= PLAY_MODE_BATTLE and GAMESTATE:GetPlayMode() ~= PLAY_MODE_RAVE;
		LoadActor( "_extra1" ) .. {
			Name="Extra1";
			StartTransitioningCommand=cmd(visible,GAMESTATE:GetEarnedExtraStage() == 'EarnedExtraStage_Extra1');
		};
		LoadActor( "_extra2" ) .. {
			Name="Extra2";
			StartTransitioningCommand=cmd(visible,GAMESTATE:GetEarnedExtraStage() == 'EarnedExtraStage_Extra2');
		};
		LoadActor( HDActor("cleared") ) .. {
			Name="Cleared";
			InitCommand=cmd(Center;);
			StartTransitioningCommand=cmd(visible,GAMESTATE:GetEarnedExtraStage() == 'EarnedExtraStage_No');
			OnCommand=cmd(diffusealpha,0;sleep,1;linear,0.5;diffusealpha,1;sleep,2);
		};
	};
	-- Winner
	Def.ActorFrame {
		Condition=GAMESTATE:GetPlayMode() == PLAY_MODE_BATTLE or GAMESTATE:GetPlayMode() == PLAY_MODE_RAVE;
		LoadActor( HDActor("p1 win") ) .. {
			InitCommand=cmd(Center);
			StartTransitioningCommand=cmd(hide_if,not GAMESTATE:IsWinner(PLAYER_1));
			OnCommand=cmd(diffusealpha,0;sleep,1.5;linear,0.5;diffusealpha,1;sleep,2);
		};
		LoadActor( HDActor("p2 win") ) .. {
			InitCommand=cmd(Center);
			StartTransitioningCommand=cmd(hide_if,not GAMESTATE:IsWinner(PLAYER_2));
			OnCommand=cmd(diffusealpha,0;sleep,1.5;linear,0.5;diffusealpha,1;sleep,2);
		};
		LoadActor( HDActor("draw") ) .. {
			InitCommand=cmd(Center);
			StartTransitioningCommand=cmd(hide_if,not GAMESTATE:IsDraw());
			OnCommand=cmd(diffusealpha,0;sleep,1.5;linear,0.5;diffusealpha,1;sleep,2);
		};
	};

	-- Demonstration
	Def.ActorFrame {
		Condition=GAMESTATE:IsDemonstration();
		Def.Quad {
			InitCommand=cmd(FullScreen;diffuse,color("0,0,0,1"));
			OnCommand=cmd(sleep,1.5;diffusealpha,0);
		};
	};
};

return t;
